#include <p30fxxxx.h>
#include <outcompare.h>

/* These devices support OutputCompare 5 thru OutputCompare 8 */
#if defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || defined(__dsPIC30F6011__) || \
    defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || defined(__dsPIC30F6013__) || \
    defined(__dsPIC30F6014__)

/********************************************************************
*    Function Name:  ReadRegOC6		                            *
*    Description:    In Non PWM Mode, this function reads the OCRS  *
*                    reg or OCR reg based on input parameter        *
*    Parameters:     char reg                                       *
*    Return Value:   unsigned int OCRS (if reg is 0)                *
*                    or OCR (if reg is 1)                           *
********************************************************************/

unsigned int ReadRegOC6(char reg)
{   
    
    /* check if OC is in NON_PWM Mode */
    if((OC6CONbits.OCM & 0x06) != 0x06) 
    {                                                    
        if(reg)
        {       
            return OC6R; /* Output Compare main Register */
            
        }     
        return OC6RS;    /* Output Compare Secondary Register */
    }  
    return -1;  
}

#endif
